import seaborn as sns
import matplotlib.pyplot as plt
import pandas

data = pandas.read_csv('data.csv')

sns.set_theme(style="ticks")

f, ax = plt.subplots(figsize=(4, 2))

sns.boxplot(x="line", y="height", data=data,width=.4, palette="vlag")

# Add in points to show each observation
sns.stripplot(x="line", y="height", data=data,size=3, color=".3", linewidth=0)

# Tweak the visual presentation
ax.xaxis.grid(True)
ax.set(ylabel="")

plt.savefig('height.pdf',format='pdf')
plt.show()
